document.addEventListener('DOMContentLoaded', function() {
    // Adiciona interatividade aos pontos do mapa
    const mapPoints = document.querySelectorAll('.map-point');
    
    mapPoints.forEach(point => {
        point.addEventListener('mouseenter', function() {
            const company = this.getAttribute('data-company');
            const clientItems = document.querySelectorAll('.client-item');
            
            clientItems.forEach(item => {
                if (item.querySelector('.client-name').textContent === company) {
                    item.style.transform = 'scale(1.05)';
                    item.style.boxShadow = '0 15px 30px rgba(228, 69, 29, 0.2)';
                }
            });
        });

        point.addEventListener('mouseleave', function() {
            const clientItems = document.querySelectorAll('.client-item');
            clientItems.forEach(item => {
                item.style.transform = '';
                item.style.boxShadow = '';
            });
        });
    });
});